//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//
//
//---------------------------

#include "math.h"
#include "mbs_data.h"
#include "set_output.h"
#include "user_model.h"
#include "user_all_id.h"
#include "mbs_project_interface.h"

#include "mbs_matrix.h"
double* user_ExtForces(double PxF[4], double RxF[4][4], 
                       double VxF[4], double OMxF[4], 
                       double AxF[4], double OMPxF[4], 
                       MbsData *mbs_data, double tsim,int ixF)
{    
    double Fx=0.0, Fy=0.0, Fz=0.0;
    double Mx=0.0, My=0.0, Mz=0.0;
    double dxF[4] = {0.0, 0.0, 0.0, 0.0};
    double *SWr = mbs_data->SWr[ixF];
    int flag_straight_vert_rail, flag_sin_vert_rail, flag_ramp_vert_rail;
    UserModel* um = mbs_data->user_model;
    //flag_straight_vert_rail = (int) um->process.flag_straight_vert_rail;
    //flag_sin_vert_rail      = (int) um->process.flag_sin_vert_rail;
    //flag_ramp_vert_rail     = (int) um->process.flag_ramp_vert_rail;

	flag_straight_vert_rail = (int)mbs_data->process;
	flag_sin_vert_rail = (int)mbs_data->process;
	flag_ramp_vert_rail = (int)mbs_data->process;
    
    
    int idpt = 0;
    idpt = mbs_data->xfidpt[ixF];
    dxF[1] = mbs_data->dpt[1][idpt];
    dxF[2] = mbs_data->dpt[2][idpt];
    dxF[3] = mbs_data->dpt[3][idpt];

    // nB: Unit vector perpendicular to wheel plane
    double nB[4] = {3.0, 0.0, 0.0, 0.0};
    nB[1]=RxF[2][1];
    nB[2]=RxF[2][2];
    nB[3]=RxF[2][3];

    // nS: Unit vector in the direction of the positive z-axis 
    double nS[4] = {3.0, 0.0, 0.0, 0.0};
    nS[3] = 1.0;
    
    // nL
    double nL[4] = {3.0, 0.0, 0.0, 0.0};
    cross_product(nB, nS, nL);
    
    // cosphi : camber angle
    double gamma, cosphi;
    gamma  = - asin(nB[3]);
    cosphi = cos(gamma);
    
    // steer angle
    double delta;
    delta = atan(nL[2]/nL[1]);
    
    // model characteristics
    double z_poster;
    double K_wheel;
    double R_wheel;
    z_poster = mbs_data->q[T3_poster_id];
    K_wheel  = um->WHEEL.K;
    R_wheel  = um->WHEEL.rnom;
    
    // crushing calculation
    double e;
    e = PxF[3] - z_poster - R_wheel*cosphi;
    
    if (e < 0.0) {
        dxF[3] = - PxF[3] + z_poster;   
    }
    
    else {
        dxF[3] = - R_wheel * cosphi;
    }
    
    
    // force calculation
    if(mbs_data->process == 2){
        Fz = -K_wheel * e;
    }
    
    else {
        if(e>0.0) {
            Fz = 0.0;
        }
        
        else {
            Fz = -K_wheel * e;
        }
    }
       
    // set all the outputs
    if(mbs_data->process == 51){ //51
        set_output_value(PxF[1], 1, "kinematics");
        set_output_value(PxF[2], 2, "kinematics");
        set_output_value(PxF[3], 3, "kinematics");
        set_output_value(gamma, 4, "kinematics");
        set_output_value(delta, 5, "kinematics");
    }
    else if(mbs_data->process == 31){
        set_output(Fz,"Fz");
        set_output(AxF[3],"Az");
        set_output(VxF[3],"Vz");
        set_output(PxF[3],"Pz"); 
    }  
	else{
		set_output(Fz, "Fz");
		set_output(AxF[2], "A");
		set_output(VxF[2], "V");
		set_output(PxF[2], "P");
		set_output(PxF[3], "Pz");
		set_output(VxF[3], "Vz");
		set_output(AxF[3], "Az");
	}
    /*else {
        set_output(Fz,'Fz');
        set_output(AxF[2],'A');
        set_output(VxF[2],'V');
        set_output(PxF[2],'P');
		set_output(PxF[3], 'Pz'); // , PxF[3], 'Pz');
    }*/
    
    
    SWr[1]=Fx;
    SWr[2]=Fy;
    SWr[3]=Fz;
    SWr[4]=Mx;
    SWr[5]=My;
    SWr[6]=Mz;
    SWr[7]=dxF[1];
    SWr[8]=dxF[2];
    SWr[9]=dxF[3];

    return SWr;
}

 
